/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning;

import cz.insophy.inplan.planning.PlanningAlgorithmSupport;
import cz.insophy.inplan.planning.PlanningEvent;
import cz.insophy.inplan.planning.PlanningUnit;
import cz.insophy.inplan.util.Localizer;

public class PlanningProgressEvent
extends PlanningEvent {
    private static final long serialVersionUID = 1L;
    private final int iterNo;
    private final int iterCnt;
    private PlanningUnit unit;
    private final int unitNo;
    private final int unitCnt;
    private final double fitness;

    public PlanningProgressEvent(PlanningAlgorithmSupport source) {
        super(source);
        this.iterNo = source.iterNo.get();
        this.iterCnt = source.iterCnt;
        this.unit = source.unit;
        this.unitNo = source.unitNo.get();
        this.unitCnt = source.unitCnt;
        this.fitness = source.fitness;
    }

    public String getLocalizedProgressMessage() {
        return Localizer.getString("planning_support.event_message", this.unit.getLocalizedName(), this.unitNo, this.unitCnt, this.iterNo, this.iterCnt);
    }

    public int getIteration() {
        return this.iterNo;
    }

    public int getIterationCount() {
        return this.iterCnt;
    }

    public int getUnit() {
        return this.unitNo;
    }

    public int getUnitCount() {
        return this.unitCnt;
    }

    public double getFitness() {
        return this.fitness;
    }
}

